/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.requests.PhoneListRequestBody;
import com.ibm.hwmca.fw.rcs.conndata.RetainUpdatableFile;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PhoneListRequestProcessor
implements RsfResultProcessor {
    private static String TRACE_MASKF = "XRSFPHLF";
    private static String TRACE_MASKT = "XRSFPHLT";
    private static String TRACE_MASKD = "XRSFPHLD";
    private static String className = "com.ibm.hwmca.base.rsf.requests.PhoneListRequestProcessor";
    private static String bundleName = "com/ibm/hwmca/base/rsf/res/BaseRsfRes";
    private static LocalizableText desc = new LocalizableText(bundleName, "RsfAccountFiles.Download");

    public static void getRetainPhoneList(List files) {
        try {
            Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor: getRetainPhoneList");
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getRsf("com.ibm.hwmca.base.rsf.BaseRsfImpl");
            if (rsf != null) {
                Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor: got RemoteSupport Facility");
                PhoneListRequestBody body = new PhoneListRequestBody();
                body.initializeMachineInformation();
                body.initializeUpdateList();
                body.initializeFileList(files);
                Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor: built RsfRequestBody");
                RsfRequest req = rsf.newRequestInstance(body, className, desc);
                Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor: got new request instance");
                req.submit();
                Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor: submitted request");
            } else {
                Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor: no RemoteSupport Facility");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "PhoneListRequestProcessor Submission Error ");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        ArrayList phoneFiles;
        PhoneListRequestBody body;
        Trace.trace(TRACE_MASKT, "-> PhoneListRequestProcessor::rsfRequestCompleted()");
        if (result.getStatusCode() != 1) {
            Trace.trace(TRACE_MASKT, "<- PhoneListRequestProcessor::rsfRequestCompleted() unsuccessful result");
            return;
        }
        try {
            body = (PhoneListRequestBody)request.getBody();
        }
        catch (ClassCastException e) {
            Trace.trace(TRACE_MASKF, "PhoneListRequestProcessor.rsfRequestCompleted: error casting request body");
            Trace.trace(TRACE_MASKF, e);
            return;
        }
        RsfResultDetails details = result.getDetails();
        if (details != null && (phoneFiles = (ArrayList)details.getAttribute("Files downloaded")) != null) {
            boolean notFound = false;
            Iterator filenames = phoneFiles.iterator();
            while (filenames.hasNext()) {
                String phoneFile = (String)filenames.next();
                Trace.trace(TRACE_MASKF, "PhoneListRequestProcessor.rsfRequestCompleted: got filename " + phoneFile);
                RetainUpdatableFile file = body.getRetainUpdatableFile(phoneFile);
                if (file != null) {
                    Trace.trace(TRACE_MASKF, "PhoneListRequestProcessor.rsfRequestCompleted: refreshing RetainUpdatableFile");
                    try {
                        file.refresh();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Trace.trace(TRACE_MASKD, "PhoneListRequestProcessor.rsfRequestCompleted: refreshed");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "PhoneListRequestProcessor.rsfRequestCompleted: RETAIN updatable file not found in request body for '" + phoneFile + "'. ");
                if (notFound) continue;
                notFound = true;
                Trace.trace(TRACE_MASKF, "PhoneListRequestProcessor: Existing mapping=" + body.showMapping());
            }
        }
        Trace.trace(TRACE_MASKT, "<- PhoneListRequestProcessor::rsfRequestCompleted()");
    }
}

